#include <allegro.h>
#include <memory.h>

#include "main.h"
#include "army.h"
#include "map.h"

ARMY* army_add(ARMY **armies)
{
	ARMY *new_army = (ARMY *) malloc(sizeof(ARMY));
	static int id = 0;

	if (new_army)
	{
		if (++id == 0) ++id;
		new_army->id = id;
		new_army->idle = TRUE;
		new_army->moves_left = 0;
		new_army->player = -1;
		new_army->x = -1; new_army->y = -1;
		new_army->dx = -1; new_army->dy = -1;
		new_army->next = *armies;
		*armies = new_army;
	}

	return new_army;
	
}

ARMY *army_remove(ARMY **armies, ARMY *army)
{
	ARMY *prev = NULL;
	ARMY *current = *armies;

	while (current)
	{
		if (current == army)
		{
			if (!prev)
				*armies = current->next;
			else
				prev->next = current->next;

			current = army->next;
			free(army);

			return current;			
		}

		prev = current;
		current = current->next;
	}

	return NULL;
}

void army_destroy(ARMY **armies)
{
	ARMY *army = *armies;
	while (army)
	{
		ARMY *tmp = army->next;
		free(army);
		army = tmp;
	}

	*armies = 0;
}

/*
	Check to see if any army is at the given x,y location.
	Returns the player# who owns the troops.
*/
int army_check_spot(ARMY *army, int x, int y)
{
	while (army)
	{
		if (army->x == x && army->y == y)
		{
			return army->player;
		}
		army = army->next;
	}
	return -1;
}

/*
	Prints the armies & size at the given x,y location.
*/
void army_print(ARMY *army, int x, int y, BITMAP *buffer, int bx, int by)
{
	int c = 0;

	while (army)
	{
		if (army->idle == FALSE && army->x == x && army->y == y)
		{
			textprintf_ex(buffer, font64, bx + (c%3) * 80, by + (c/3) * 8, 4+army->player, 0, "^_%d", army->size);			
			c++;
			if (c == 10) break;
		}
		army = army->next;
	}
}

/*
	Returns the idle troops at the given x,y location.
	Because they are always merged end of turn, we can do this.
*/
ARMY *army_get_idle(ARMY *army, int x, int y)
{
	while (army)
	{
		if (army->idle && army->x == x && army->y == y)
		{
			return army;
		}
		army = army->next;
	}
	return NULL;
}

/*
	Check to see if an enemy is occupying this territory.
	We return the enemy # because returning the ARMY
	isn't very useful, as there may be more than one (due to
	moving troops)
*/
int army_get_enemy(ARMY *army, int x, int y, int player)
{
	while (army)
	{
		if (army->player != player && army->x == x && army->y == y)
		{
			return army->player;
		}
		army = army->next;
	}
	return -1;
}

/*
	Get the total # of enemy troops at a spot. During a turn,
	there may be more than one enemy at a location, so we cannot
	just stop after finding the first one. 
*/
int army_get_enemy_size(ARMY *army, int x, int y, int player)
{
	int total = 0;
	while (army)
	{
		if (army->player != player && army->x == x && army->y == y)
		{
			total += army->size;
		}
		army = army->next;
	}

	return total;
}

